using System;

namespace Implab {
    /// <summary>
    /// Базовыйй класс для создания обработчиков результов выполнения обещаний.
    /// Данный объект связывает обработчик и обешание, при этом для выполнения
    /// обработчика будет использоваться диспетчер.
    /// </summary>
    abstract class PromiseReaction<T> : IResolvable<T> {
        readonly IDispatcher m_dispatcher;

        protected PromiseReaction(IDispatcher dispatcher) {
            m_dispatcher = dispatcher;
        }

        protected Action<T> FulfilHandler { get; set; }

        protected Action<Exception> RejectHandler { get; set; }

        public void Reject(Exception error) {
            if (RejectHandler == null)
                DefaultReject(error);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(RejectHandler, error);
            else
                RejectHandler(error);
        }

        public void Resolve(T result) {
            if (FulfilHandler == null)
                DefaultResolve(result);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(FulfilHandler, result);
            else
                FulfilHandler(result);
        }

        protected abstract void DefaultResolve(T result);

        protected abstract void DefaultReject(Exception reason);
    }
}